### non-linear regression, first pass
graphics.off()
x11(height = 6, width = 8)

library(MASS)
xyplot(Weight ~ Days, wtloss)

###
graphics.off()
x11(height = 6, width = 8)

wt.lm0<-lm(Weight ~ poly(Days, 2), wtloss)
wt.lm1 <- lm(Weight ~ poly(Days, 3), wtloss)

anova(wt.lm0,wt.lm1)

Wtloss <- with(wtloss,
  data.frame(Days = seq(min(Days), max(Days), len = 1000),
             Weight = NA))
Wtloss <- rbind(Wtloss, wtloss)
Wtloss <- Wtloss[order(Wtloss$Days), ]

Wtloss$pWeight <- predict(wt.lm1, Wtloss)
Wtloss$pWeight0 <- predict(wt.lm0, Wtloss)

cbind(Wtloss$pWeight,Wtloss$pWeight0)

library(lattice)
xyplot(Weight ~ Days, Wtloss,
  panel = function(x, y, ...) {
	   panel.xyplot(x, y, ...)
	   panel.lines(x, Wtloss$pWeight, col = "red")
           panel.lines(x, Wtloss$pWeight0, col = "blue")
})

### Be careful with the parameters interpretation
### See the difference between two fitted curves
plot(0:700, predict(wt.lm1, data.frame(Days = 0:700)),
  type = "l", xlab = "Days", ylab = "Weight", col = "red")
with(wtloss, points(Days, Weight, pch = 4, col = "blue"))

plot(0:700, predict(wt.lm0, data.frame(Days = 0:700)),
  type = "l", xlab = "Days", ylab = "Weight", col = "red")
with(wtloss, points(Days, Weight, pch = 4, col = "blue"))


#tmp <- data.frame(Days = 0:700)
#tmp$Weight <- predict(wt.lm1, tmp)
#xyplot(Weight ~ Days, tmp, type = "l")


###
wt.nls0 <-
	nls(Weight ~ b0 + b1 * 2^( - Days/tau), wtloss,
	start = c(b0 = 70, b1 = 122, tau = 150),
	trace = T)
#b0  o valor assintotico do ajuste


###
lines(0:700, predict(wt.nls0, data.frame(Days = 0:700)), col = "green4")
abline(h = coef(wt.nls0)[1], lty = "dashed", col = "blue")

###
rg <- range(wtloss$Days)
del <- 0.25*(rg[2] - rg[1])
eta <- predict(wt.lm1, data.frame(Days = rg[1] + 1:3*del))
deta <- diff(eta)
t0 <- as.vector(del*log(2)/log(deta[1]/deta[2]))
ab <- as.vector(coef(lm(Weight ~ I(2^(-Days/t0)), wtloss)))
init <- c(b0 = ab[1], b1 = ab[2], tau = t0)
wt.nls1 <- nls(Weight ~ b0+b1*2^(-Days/tau), wtloss,
	start = init, trace = T)

###
ival <- function(y, x) {
  rg <- range(x)
  del <- 0.25 * (rg[2] - rg[1])
  fm <- lm(y ~ x + I(x^2))
  dat <- data.frame(x = rg[1] + 1:3 * del)
  eta <- predict(fm, dat)
  deta <- diff(eta)
  t0 <- as.vector((del * log(2))/log(deta[1]/deta[2]))
  ab <- as.vector(coef(lm(y ~ I(2^( - x/t0)))))
  c(b0 = ab[1], b1 = ab[2], tau = t0)
}
with(wtloss, ival(Weight, Days))


###
negexp <- deriv(~ b0 + b1*2^(-x/tau),
	c("b0", "b1", "tau"),
	function(x, b0, b1, tau) {})

wt.nls2 <- nls(Weight ~ negexp(Days, b0, b1, tau),
  wtloss, start = with(wtloss, ival(Weight, Days)),
  trace = T)
  
###
negexp

###
SSival <- function(mCall, data, LHS)  {
#
# y ~ b0 + b1*2^(-x/tau)
#
  x <- eval(mCall[["x"]], data)
  y <- eval(LHS, data)
  rg <- range(x)
  del <- 0.25 * (rg[2] - rg[1])
  fm <- lm(y ~ x + I(x^2))
  dat <- data.frame(x = rg[1] + 1:3 * del)
  eta <- predict(fm, dat)
  deta <- diff(eta)
  t0 <- as.vector((del * log(2))/log(deta[1]/deta[2]))
  ab <- as.vector(coef(lm(y ~ I(2^( - x/t0)))))
  	pars <- list(ab[1], ab[2], t0)
  	names(pars) <- mCall[c("b0", "b1", "tau")]
	pars
}

###
SSnegexp <- selfStart(model = ~ b0 + b1*2^(-x/tau),
   initial = SSival, parameters = c("b0", "b1", "tau"),
   template = function(x, b0, b1, tau) {})

wt.nls3 <- nls(Weight ~ SSnegexp(Days, a, b, t), wtloss, trace = T)

###
summary(wt.nls3)

### stormer data

SSival.storm <- function(mCall, data, LHS) {
#
# y ~ b*x1/(x2-theta)
#
	x1 <- eval(mCall[["x1"]], data)
	x2 <- eval(mCall[["x2"]], data)
	y <- eval(LHS, data)
	cf <- lsfit(cbind(x1, y), x2*y, int = F)$coef
	names(cf) <- mCall[c("b", "theta")]
	cf
}

storm <- selfStart(model = ~ b*x1/(x2-theta),
	initial = SSival.storm, parameters = c("b", "theta"),
	template = function(x1, x2, b, theta) {})

storm.nls1 <- nls(Time ~ storm(Viscosity, Wt, beta, tau), stormer, trace=T)

###
storm.nls1$call$trace <- FALSE
storm.pf <- profile(storm.nls1)

graphics.off()
x11(height = 4, width = 8)
par(mfrow = c(1,2))
plot(storm.pf)

graphics.off()
x11(height = 8, width = 8)
pairs(storm.pf)

###
b <- coef(storm.nls1)
se <- sqrt(diag(vcov(storm.nls1)))

del <- seq(-5, 5, length = 101)
Stm <- expand.grid(beta = b[1] + del*se[1], tau = b[2] + del*se[2])

Regfn <- with(stormer,
  outer(Viscosity, Stm$beta)/
			outer(Wt, Stm$tau, "-"))
res <- matrix(stormer$Time, nrow(stormer), nrow(Stm)) - Regfn
Stm$RSS <- colSums(res*res)/1000
Stm$RSS <- with(Stm, log10(1 + RSS - min(RSS)))

levelplot(RSS ~ beta + tau, Stm, contour = TRUE, pretty = TRUE,
  col.regions = rev(heat.colors(100)))

cont <- round(quantile(Stm$RSS,0:10/10), 2)
contourplot(RSS ~ beta+tau, Stm, at=cont)

### BOOTSTRAP
m <- v <- numeric(100)
for(j in 1:100) {
  sam <- factor(sample(1:50, 50, rep = T), levels = 1:50)
  sam <- table(sam)
  m[j] <- mean(sam)
  v[j] <- var(sam)
}

rv <- rexp(5000, 1)

###
B <- matrix(NA, 1000, 2)
n <- nrow(stormer)
for(i in 1:1000) {
  w <- rexp(n, 1)#generate weights
  w <- n * w/sum(w)#normalize weights
  tmp <- try(update(storm.nls1, weights = w))
  if(class(tmp)[1] != "try-error")
    B[i,  ] <- coef(tmp)
}

B1 <- matrix(NA, 1000, 2)
rs <- scale(resid(storm.nls1), scale = F)
mean(rs)
rs<-rs-mean(rs)
mean(rs)
yt <- stormer$Time - rs
for(i in 1:1000) {
  ThisY <- as.vector(yt + sample(rs, rep = T))
  tmp <- try(update(storm.nls1, ThisY ~ .))
  if(class(tmp)[1] != "try-error")
    B1[i,  ] <- coef(tmp)
}
apply(B, 2, quantile, c(1, 39)/40)

apply(B1, 2, quantile, c(1, 39)/40)

tau <- qt(0.975, nrow(stormer)-2)
b <- coef(storm.nls1)
se <- sqrt(diag(vcov(storm.nls1)))

rbind(b - tau*se, b + tau*se)
plot(B)
points(B1,pch=4,col=3)
